<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common">

	<!-- Creates [ClassName].html file -->

	<!-- START DOCUMENT TEMPLATE-->
	<!-- ======================================================================================================= -->

	<xsl:template name="classdoc">
		<xsl:param name="packageName"/>
		<xsl:param name="packageQualifiedName"/>
		<xsl:param name="packagePath"/>
		<xsl:variable name="classifierShortName">
			<xsl:call-template name="classifierShortName">
				<xsl:with-param name="class" select="current()"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/', $packagePath, '/', $classifierShortName, '.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/{$packagePath}/{$classifierShortName}.html">
			<html>
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			<xsl:call-template name="ImgLoaderScript"/>
			</head>
			
			<!-- NAVBAR -->
			<xsl:if test="$navbar_param">
				<xsl:call-template name="ClassNavBar">
					<xsl:with-param name="class" select="current()"></xsl:with-param>
					<xsl:with-param name="header" select="'true'"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>			
			<hr/>

			<h2>
				<font size="-1">
					<i><xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Namespace'"/></xsl:call-template></i>					
					<xsl:apply-templates select="current()" mode="getNamespace"/><br/>
				</font>
				<br/>
				<xsl:choose>
					<xsl:when test="@type='Class'">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Class'"/></xsl:call-template>					
					</xsl:when>
					<xsl:when test="@type='Interface'">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Interface'"/></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='Struct'">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Struct'"/></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='Enum'">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Enum'"/></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='Delegate'">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Delegate'"/></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='Module'">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'Module'"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@type"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$classifierShortName"/>
			</h2>

			<xsl:if test="(@type='Class') and not($prj_lang='design')">
				<pre>
					<!-- Count depth of class hierarchy tree -->
					<xsl:variable name="hierarchyDepth">
						<xsl:call-template name="countHierarchyDepth">
							<xsl:with-param name="class" select="current()"></xsl:with-param>
							<xsl:with-param name="thisNode" select="current()"></xsl:with-param>
							<xsl:with-param name="depth" select="' '"/>
						</xsl:call-template>
					</xsl:variable>

					<!-- Print class hierarchy tree -->
					<xsl:call-template name="classHierarchy">
						<xsl:with-param name="class" select="current()"></xsl:with-param>
						<xsl:with-param name="thisNode" select="current()"></xsl:with-param>
						<xsl:with-param name="depth" select="$hierarchyDepth"/>
						<xsl:with-param name="currentDepth" select="0"/>
					</xsl:call-template>
					
				</pre>
			</xsl:if>

			<!-- Print inheritance items -->
			<xsl:variable name="allSuperInterfaces">
				<xsl:apply-templates select="current()" mode="superInterfaces"/>
			</xsl:variable>
			<xsl:if test="string-length($allSuperInterfaces) &gt; 0">
				<xsl:variable name="title">
					<xsl:choose> 
						<xsl:when test="@type='Class' or @type='Struct'">
							<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'all_implemented_interfaces'"/></xsl:call-template>					
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'all_superinterfaces'"/></xsl:call-template>					
						</xsl:otherwise>
					</xsl:choose> 
				</xsl:variable> 

				<xsl:call-template name="printInheritanceItem">
					<xsl:with-param name="title" select="$title"/>
					<xsl:with-param name="text" select="$allSuperInterfaces"/>
				</xsl:call-template>
			</xsl:if>

			<xsl:if test="@type='Interface'">
				<xsl:variable name="subInterfaces">
					<xsl:apply-templates select="current()" mode="subInterfaces"/>
				</xsl:variable>
				<xsl:if test="string-length($subInterfaces) &gt; 0">
					<xsl:variable name="title">
						<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'all_known_subinterfaces'"/></xsl:call-template>					
					</xsl:variable>
					<xsl:call-template name="printInheritanceItem">
						<xsl:with-param name="title" select="$title"/>
						<xsl:with-param name="text" select="$subInterfaces"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:if>

			<!-- Collect and print subclasses -->
			<xsl:variable name="allSubclasses">
				<xsl:apply-templates select="current()" mode="subClasses">
					<xsl:with-param name="onlyDirect">
						<xsl:choose> 
							<xsl:when test="@type='Class'">
								<xsl:value-of select="'true'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'false'"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param> 
				</xsl:apply-templates>
			</xsl:variable>
			
			<xsl:if test="string-length($allSubclasses) &gt; 0">
				<xsl:variable name="title">
					<xsl:choose> 
						<xsl:when test="@type='Class'">
							<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'direct_known_subclasses'"/></xsl:call-template>					
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'all_known_implementing_classes'"/></xsl:call-template>					
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable> 
				
				<xsl:call-template name="printInheritanceItem">
					<xsl:with-param name="title" select="$title"/>
					<xsl:with-param name="text" select="$allSubclasses"/>
				</xsl:call-template>
			</xsl:if>
			
			<xsl:variable name="enclosingClass" select="parent::Classifier"/>
			<xsl:if test="$enclosingClass">
				<xsl:variable name="parentShortName">
					<xsl:call-template name="classifierShortName">
						<xsl:with-param name="class" select="$enclosingClass"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="pathEnclosing">
					<xsl:call-template name="RelPathResolver">
						<xsl:with-param name="element" select="$enclosingClass"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="text">
					<a href="{$pathEnclosing}">
						<xsl:value-of select="$parentShortName"/>
					</a>
				</xsl:variable>
				<xsl:variable name="enclclass">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'enclosing_class'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="printInheritanceItem">
					<xsl:with-param name="title" select="$enclclass"/>
					<xsl:with-param name="text" select="$text"/>
				</xsl:call-template>
			</xsl:if>
			<hr/>
			<dl>
				<dt/>
				<!-- Definition string -->

        <!--xsl:apply-templates select="current()" mode="DefinitionString"/-->
				<xsl:call-template name="ClassifierDefinitionString">
					<xsl:with-param name="class" select="current()"></xsl:with-param>
				</xsl:call-template>
				<b><xsl:value-of select="$classifierShortName"/></b>
				<xsl:if test="@type='Delegate'">
					<xsl:text>(</xsl:text>
					<xsl:variable name="params" select="Parameter"></xsl:variable>
					<xsl:for-each select="$params">
						<xsl:variable name="typeref">
							<xsl:call-template name="typeRefHandler">
								<xsl:with-param name="parameter" select="current()"></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
				
						<xsl:choose>
							<xsl:when test="$prj_lang='csharp'">
								<xsl:value-of select="$typeref"></xsl:value-of>
								<xsl:text> </xsl:text>
								<xsl:value-of select="@elementName"></xsl:value-of>
								<xsl:if test="not(position()=last())">
									<xsl:text>, </xsl:text>
								</xsl:if>
							</xsl:when>
              <xsl:when test="$prj_lang='delphi'">
                <xsl:value-of select="@elementName"></xsl:value-of>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="$typeref"></xsl:value-of>
                <xsl:if test="not(position()=last())">
                  <xsl:text>; </xsl:text>
                </xsl:if>
              </xsl:when>
              <xsl:when test="$prj_lang='vbnet'">
								<xsl:value-of select="@elementName"></xsl:value-of>
								<xsl:text> As </xsl:text>
								<xsl:value-of select="$typeref"></xsl:value-of>
								<xsl:if test="not(position()=last())">
									<xsl:text>, </xsl:text>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="@Direction">
									<xsl:value-of select="@Direction"></xsl:value-of>
									<xsl:text> </xsl:text>
								</xsl:if>
								<xsl:value-of select="@elementName"></xsl:value-of>
								<xsl:text>:</xsl:text>
								<xsl:value-of select="$typeref"></xsl:value-of>
								<xsl:if test="@Multiplicity">
									<xsl:text>[</xsl:text>
									<xsl:value-of select="@Multiplicity"></xsl:value-of>
									<xsl:text>]</xsl:text>
								</xsl:if>
								<xsl:if test="@DefaultValue">
									<xsl:text>=</xsl:text>
									<xsl:value-of select="@DefaultValue"></xsl:value-of>
								</xsl:if>
								<xsl:if test="not(position()=last())">
									<xsl:text>, </xsl:text>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<xsl:text>)</xsl:text>
          <xsl:if test="$prj_lang='delphi'">
            <xsl:variable name="typeName">
              <xsl:call-template name="typeRefHandler">
                <xsl:with-param name="parameter" select="ReturnType"/>
              </xsl:call-template>
            </xsl:variable>
            <xsl:if test="string-length(string($typeName)) &gt; 0">
              <xsl:text>: </xsl:text>
              <xsl:value-of select ="$typeName"/>
            </xsl:if>
          </xsl:if>
        </xsl:if>

				<xsl:variable name="directSuperInterfaces">
					<xsl:apply-templates select="current()" mode="superInterfaces">
						<xsl:with-param name="onlyDirect" select="'true'"/>
					</xsl:apply-templates>
				</xsl:variable>
				<xsl:variable name="extends">
					<xsl:choose>
						<xsl:when test="@type='Class' or @type='Struct'">
							<xsl:apply-templates select="current()" mode="superClasses">
								<xsl:with-param name="onlyDirect" select="'true'"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="$directSuperInterfaces"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<xsl:variable name="extendsText">
					<xsl:choose>
						<xsl:when test="string-length($extends) &gt; 0">
							<xsl:copy-of select="$extends"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="(@type='Class') and not ($prj_lang='design')">
								<xsl:text>System.Object&#xA;</xsl:text>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:if test="string-length($extendsText) &gt; 0">
					<dt/>
					<xsl:choose>
						<xsl:when test="$prj_lang='vbnet'">
							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'inherits'"></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'extends'"></xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>	
					</xsl:choose>
					<xsl:copy-of select="$extendsText"/>
				</xsl:if>
				<xsl:if test="@type='Class' or @type='Struct'">
					<xsl:if test="string-length($directSuperInterfaces) &gt; 0">
						<dt/>
						<xsl:choose>
							<xsl:when test="$prj_lang='vbnet'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'implements_vb'"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'implements'"></xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>	
						</xsl:choose>
						<xsl:copy-of select="$directSuperInterfaces"/>
					</xsl:if>
				</xsl:if>
			</dl>
			<p/>
			<xsl:call-template name="printProperties">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
				<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
			</xsl:call-template>
			<hr/>
			<p/>
			<!-- Process fields and methods-->
			<xsl:variable name="constructors" select="Method[@name=parent::node()/@name] | Method[@name='New'] | Method[@isConstructor='true']"/>
			<xsl:variable name="destructors" select="Method[@name=concat('~',parent::node()/@name)]"/>
			<xsl:variable name="indexers" select="Method[@isIndexer='true']"/>
			<xsl:variable name="methods" select="Method[ count(. | $constructors | $destructors | $indexers)!= count($constructors | $destructors | $indexers)]"/><!--not(@name=parent::node()/@name)]"/-->
			<xsl:variable name="events" select="Field[@isEvent='true']"/>
			<xsl:variable name="properties" select="Field[@isProperty='true']"/>
			<xsl:variable name="ports" select="Field[@fieldType='Port']"/>
			<xsl:variable name="parts" select="Field[@fieldType='Part']"/>
			<xsl:variable name="colls" select="Field[@fieldType='Coll']"/>
			<xsl:variable name="fields" select="Field[ count(. | $colls | $parts | $ports | $events | $properties)!= count( $colls | $parts | $ports | $events | $properties)]"/>
			
			<!-- Print inner class summary -->
			<xsl:variable name="InnerClassSummary">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'inner_class_summary'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="InnerClassSummary">
				<xsl:with-param name="title" select="$InnerClassSummary"/>
				<xsl:with-param name="nodeset" select="child::Classifier[@type='Class']"></xsl:with-param>
			</xsl:call-template>

			<!-- Print inner interface summary -->
			<xsl:variable name="InnerInterfaceSummary">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'inner_interface_summary'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="InnerClassSummary">
				<xsl:with-param name="title" select="$InnerInterfaceSummary"/>
				<xsl:with-param name="nodeset" select="child::Classifier[@type='Interface']"></xsl:with-param>
			</xsl:call-template>

			<!-- Print inner struct summary -->
			<xsl:variable name="InnerStructSummary">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'inner_struct_summary'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="InnerClassSummary">
				<xsl:with-param name="title" select="$InnerStructSummary"/>
				<xsl:with-param name="nodeset" select="child::Classifier[@type='Struct']"></xsl:with-param>
			</xsl:call-template>

			<!-- Print inner enum summary -->
			<xsl:variable name="InnerEnumSummary">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'inner_enum_summary'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="InnerClassSummary">
				<xsl:with-param name="title" select="$InnerEnumSummary"/>
				<xsl:with-param name="nodeset" select="child::Classifier[@type='Enum']"></xsl:with-param>
			</xsl:call-template>

			<!-- Print inner delegate summary -->
			<xsl:variable name="InnerDelegateSummary">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'inner_delegate_summary'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="InnerClassSummary">
				<xsl:with-param name="title" select="$InnerDelegateSummary"/>
				<xsl:with-param name="nodeset" select="child::Classifier[@type='Delegate']"></xsl:with-param>
			</xsl:call-template>

			<xsl:variable name="classpath">
				<xsl:call-template name="RelPathResolver">
					<xsl:with-param name="element" select="current()"/>
				</xsl:call-template>
			</xsl:variable>
			<!-- Print fields summary table-->
			<xsl:if test="not(count($fields)=0)">
				<xsl:variable name="FieldSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Field_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createFieldSummaryTable">
					<xsl:with-param name="title" select="$FieldSummary"/>
					<xsl:with-param name="nodeSet" select="$fields"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>
			
			<xsl:if test="not(count($ports)=0)">
				<xsl:variable name="PortSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Port_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createFieldSummaryTable">
					<xsl:with-param name="title" select="$PortSummary"/>
					<xsl:with-param name="nodeSet" select="$ports"/>
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>

			<xsl:if test="not(count($parts)=0)">
				<xsl:variable name="PartSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Part_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createFieldSummaryTable">
					<xsl:with-param name="title" select="$PartSummary"/>
					<xsl:with-param name="nodeSet" select="$parts"/>
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>
			
			<xsl:if test="not(count($colls)=0)">
				<xsl:variable name="CollSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Coll_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createFieldSummaryTable">
					<xsl:with-param name="title" select="$CollSummary"/>
					<xsl:with-param name="nodeSet" select="$colls"/>
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Print events summary table-->
			<xsl:if test="not(count($events)=0)">
				<xsl:variable name="EventSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Event_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createFieldSummaryTable">
					<xsl:with-param name="title" select="$EventSummary"/>
					<xsl:with-param name="nodeSet" select="$events"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print properties summary table-->
			<xsl:if test="not(count($properties)=0)">
				<xsl:variable name="PropertySummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Property_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createFieldSummaryTable">
					<xsl:with-param name="title" select="$PropertySummary"/>
					<xsl:with-param name="nodeSet" select="$properties"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>

			
			<!-- Print inheritance fields table -->
			<xsl:call-template name="InheritedFields">
				<xsl:with-param name="class" select="current()"></xsl:with-param>
				<xsl:with-param name="thisNode" select="current()"></xsl:with-param>
			</xsl:call-template>

			<!-- Print constructor summary table-->
			<xsl:if test="not(count($constructors)=0)">
				<xsl:variable name="ConstructorSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Constructor_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createConstructorSummaryTable">
					<xsl:with-param name="title" select="$ConstructorSummary"/>
					<xsl:with-param name="nodeSet" select="$constructors"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print destructor summary table-->

			<xsl:if test="not(count($destructors)=0)">
				<xsl:variable name="DestructorSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Destructor_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createDestructorSummaryTable">
					<xsl:with-param name="title" select="$DestructorSummary"/>
					<xsl:with-param name="nodeSet" select="$destructors"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print indexer summary table -->
			<xsl:if test="not(count($indexers)=0)">
				<xsl:variable name="IndexerSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Indexer_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createMethodSummaryTable">
					<xsl:with-param name="title" select="$IndexerSummary"/>
					<xsl:with-param name="nodeSet" select="$indexers"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print method summary table -->
			<xsl:if test="not(count($methods)=0)">
				<xsl:variable name="MethodSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Method_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createMethodSummaryTable">
					<xsl:with-param name="title" select="$MethodSummary"/>
					<xsl:with-param name="nodeSet" select="$methods"/>
					<!--xsl:with-param name="classpath" select="concat('file:///', $outdir,'/', $packagePath,'/',$classifierShortName,'.html')"/-->
					<xsl:with-param name="classpath" select="$classpath"/>
				</xsl:call-template>
			</xsl:if>
			<p/>

			<!-- Print inheritance methods table -->
			<xsl:call-template name="InheritedMethods">
				<xsl:with-param name="class" select="current()"></xsl:with-param>
				<xsl:with-param name="thisNode" select="current()"></xsl:with-param>
			</xsl:call-template>

			<!-- Print field detail -->
			<xsl:if test="not(count($fields)=0)">
				<xsl:variable name="FieldDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Field_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="fieldDetail">
					<xsl:with-param name="title" select="$FieldDetail"/>
					<xsl:with-param name="nodeSet" select="$fields"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print field detail -->
			<xsl:if test="not(count($ports)=0)">
				<xsl:variable name="PortDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Port_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="fieldDetail">
					<xsl:with-param name="title" select="$PortDetail"/>
					<xsl:with-param name="nodeSet" select="$ports"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Print field detail -->
			<xsl:if test="not(count($parts)=0)">
				<xsl:variable name="PartDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Part_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="fieldDetail">
					<xsl:with-param name="title" select="$PartDetail"/>
					<xsl:with-param name="nodeSet" select="$parts"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Print field detail -->
			<xsl:if test="not(count($colls)=0)">
				<xsl:variable name="CollDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Coll_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="fieldDetail">
					<xsl:with-param name="title" select="$CollDetail"/>
					<xsl:with-param name="nodeSet" select="$colls"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Print event detail -->
			<xsl:if test="not(count($events)=0)">
				<xsl:variable name="EventDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Event_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="fieldDetail">
					<xsl:with-param name="title" select="$EventDetail"/>
					<xsl:with-param name="nodeSet" select="$events"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print property detail -->
			<xsl:if test="not(count($properties)=0)">
				<xsl:variable name="PropertyDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Property_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="fieldDetail">
					<xsl:with-param name="title" select="$PropertyDetail"/>
					<xsl:with-param name="nodeSet" select="$properties"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print constructor detail -->
			<xsl:if test="not(count($constructors)=0)">
				<xsl:variable name="ConstructorDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Constructor_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="constructorDetail">
					<xsl:with-param name="title" select="$ConstructorDetail"/>
					<xsl:with-param name="nodeSet" select="$constructors"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print destructors detail -->
			<xsl:if test="not(count($destructors)=0)">
				<xsl:variable name="DestructorDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Destructor_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="destructorDetail">
					<xsl:with-param name="title" select="$DestructorDetail"/>
					<xsl:with-param name="nodeSet" select="$destructors"/>
				</xsl:call-template>
			</xsl:if>

			<!-- Print indexer detail -->
			<xsl:if test="not(count($indexers)=0)">
				<xsl:variable name="IndexerDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Indexer_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="methodDetail">
					<xsl:with-param name="title" select="$IndexerDetail"/>
					<xsl:with-param name="nodeSet" select="$indexers"/>
				</xsl:call-template>
			</xsl:if>

 			<!-- Print method detail -->
			<xsl:if test="not(count($methods)=0)">
				<xsl:variable name="MethodDetail">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Method_Detail'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="methodDetail">
					<xsl:with-param name="title" select="$MethodDetail"/>
					<xsl:with-param name="nodeSet" select="$methods"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Print Element Links-->
			<xsl:call-template name="printLinks">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="current()/Link"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="current()/Link/@metaclass"></xsl:with-param>			
			</xsl:call-template>					

			<!-- Print Element HyperLinks-->
			<xsl:call-template name="printHyperLinks">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
			</xsl:call-template>					

			<!-- NAVBAR -->
			<hr/>
			<xsl:if test="$navbar_param">
				<xsl:call-template name="ClassNavBar">
					<xsl:with-param name="class" select="current()"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>	
			<br/>
			<p/>
			<xsl:value-of select="$bottom_param"></xsl:value-of>
			</html>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
		
	</xsl:template>
	<!-- ======================================================================================================= -->
	<!-- END DOCUMENT TEMPLATE-->
	

	<!-- Count depth of class hierarchy tree -->
	<xsl:template name="countHierarchyDepth">
		<xsl:param name="class"></xsl:param>
		<xsl:param name="thisNode"></xsl:param>
		<xsl:param name="depth"/>

		<xsl:variable name="superclassID" select="$class/Extends[not(@indirectly='true')]/@idref"/>
		<xsl:choose>
			<xsl:when test="string-length($superclassID)=0">
				<xsl:value-of select="$depth" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="item" select="key('classifier', $superclassID)[@type='Class']"></xsl:variable>
				<xsl:variable name="containsNode">
					<xsl:call-template name="searchFor">
						<xsl:with-param name="where" select="$thisNode"></xsl:with-param>
						<xsl:with-param name="what" select="$item"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="string-length($containsNode) = 0">
					<xsl:call-template name="countHierarchyDepth">
						<xsl:with-param name="class" select="$item"></xsl:with-param>
						<xsl:with-param name="thisNode" select="$thisNode | $item"></xsl:with-param>
						<xsl:with-param name="depth" select="concat($depth,'  ')"/>
					</xsl:call-template>
				</xsl:if>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Print class hierarchy tree -->
	<xsl:template name="classHierarchy">
		<xsl:param name="class"></xsl:param>
		<xsl:param name="thisNode"></xsl:param>
		<xsl:param name="depth"/>
		<xsl:param name="currentDepth"/>
	
		<xsl:variable name="superclassID" select="$class/Extends[not(@indirectly='true')]/@idref"/>
	
		<xsl:choose>
			<xsl:when test="string-length($superclassID)=0">
				<xsl:text>System.Object&#xA;</xsl:text>
			</xsl:when>
			<xsl:when test="not(key('classifier', $superclassID))">
				<xsl:value-of select="$class/Extends[@idref=$superclassID]/@refFN"/>
				<xsl:text>&#xA;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="item" select="key('classifier', $superclassID)[@type='Class']"></xsl:variable>
				<xsl:variable name="containsNode">
					<xsl:call-template name="searchFor">
						<xsl:with-param name="where" select="$thisNode"></xsl:with-param>
						<xsl:with-param name="what" select="$item"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="string-length($containsNode) = 0">
					<xsl:call-template name="classHierarchy">
						<xsl:with-param name="class" select="$item"></xsl:with-param>
						<xsl:with-param name="thisNode" select="$thisNode | $item"></xsl:with-param>
						<xsl:with-param name="depth" select="$depth"/>
						<xsl:with-param name="currentDepth" select="$currentDepth+2"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:variable name="indent"> 
			<xsl:choose>
				<xsl:when test="not($currentDepth=0)">
					<xsl:value-of select="substring ($depth, $currentDepth)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($depth, ' ')" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:value-of select="$indent" />
		<xsl:text>|&#xA;</xsl:text>
		<xsl:value-of select="$indent" />
		<xsl:text>+-- </xsl:text>
		
		<xsl:variable name="quialifedName">
			<xsl:apply-templates select="$class" mode="getQualifiedName"/>
		</xsl:variable>
		<xsl:variable name="fullPath">
			<xsl:if test="not($currentDepth=0)">
				<xsl:apply-templates select="$class" mode="getRelativePath"/>
			</xsl:if>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="string-length($fullPath) &gt; 0">
				<xsl:apply-templates select="$class" mode="HRefWithImgLoad">
					<xsl:with-param name="isName" select="'1'"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="string-length($quialifedName) &gt; 0">
				<xsl:value-of select="$quialifedName"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="current()/Property[@name='Extends']"/>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:text>&#xA;</xsl:text>
	</xsl:template>
	
	
	<!-- Inheritance items -->
	<!-- ======================================================================================================= -->


	<!-- Process classifier Inheritance -->
	<xsl:template match="Classifier" mode="inheritance">
		<xsl:param name="nodeset"/>
		<xsl:param name="noderefs"/>
		<xsl:for-each select="$nodeset">
			<xsl:choose> 
				<!-- Handle references -->
				<xsl:when test="$noderefs='true'">
					<xsl:variable name="nextByRef" select="key('classifier', @idref)" />
					<xsl:variable name="fullPath">
						<xsl:apply-templates select="$nextByRef" mode="getRelativePath"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($fullPath) &gt; 0">
							<xsl:apply-templates select="$nextByRef" mode="HRefWithImgLoad"/>
							<xsl:text>  </xsl:text>
						</xsl:when>
						<xsl:when test="string-length($nextByRef) &gt; 0">
							<xsl:apply-templates select="$nextByRef" mode="getQualifiedName"/>
							<xsl:text>  </xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="current()/@refFN"></xsl:value-of>
							<xsl:text>  </xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="fullPath">
						<xsl:apply-templates select="current()" mode="getRelativePath"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($fullPath) &gt; 0">
							<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
							<xsl:text>  </xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="current()" mode="getQualifiedName"/>
							<xsl:text>  </xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<!--xsl:if test="not(position()=last())">
				<xsl:text>, </xsl:text>
			</xsl:if-->
		</xsl:for-each>
	</xsl:template>

	<!-- Print Inheritance Item -->
	<xsl:template name="printInheritanceItem">
		<xsl:param name="title"/>
		<xsl:param name="text"/>
		<dl>
			<dt/>
			<b><xsl:value-of select="$title"/></b>
			<dd>
				<xsl:copy-of select="$text"/>
			</dd>
		</dl>
	</xsl:template>

	<!-- Process super classes -->
	<xsl:template match="Classifier" mode="superClasses">
		<xsl:param name="onlyDirect"/>
		<xsl:choose> 
			<xsl:when test="$onlyDirect='true'">
				<xsl:variable name="nodeset" select="Extends[not(@indirectly='true')]"/>
				<xsl:apply-templates select="current()" mode="inheritance">
					<xsl:with-param name="nodeset" select="$nodeset"/>
					<xsl:with-param name="noderefs" select="'true'"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="nodeset" select="Extends"/>
				<xsl:apply-templates select="current()" mode="inheritance">
					<xsl:with-param name="nodeset" select="$nodeset"/>
					<xsl:with-param name="noderefs" select="'true'"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Super Interfaces for classifiers -->
	<xsl:template match="Classifier" mode="superInterfaces">
		<xsl:param name="onlyDirect"/>
		<xsl:choose> 
			<!-- Process classes -->
			<xsl:when test="@type='Class' or @type='Struct'">
				<xsl:choose> 
					<xsl:when test="$onlyDirect='true'">
						<xsl:variable name="nodeset" select="Implements[not(@indirectly='true')]"/>
						<xsl:apply-templates select="current()" mode="inheritance">
							<xsl:with-param name="nodeset" select="$nodeset"/>
							<xsl:with-param name="noderefs" select="'true'"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="nodeset" select="Implements"/>
						<xsl:apply-templates select="current()" mode="inheritance">
							<xsl:with-param name="nodeset" select="$nodeset"/>
							<xsl:with-param name="noderefs" select="'true'"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- Process interfaces -->
			<xsl:otherwise>
				<xsl:choose> 
					<xsl:when test="$onlyDirect='true'">
						<xsl:variable name="nodeset" select="Extends[not(@indirectly='true')]"/>
						<xsl:apply-templates select="current()" mode="inheritance">
							<xsl:with-param name="nodeset" select="$nodeset"/>
							<xsl:with-param name="noderefs" select="'true'"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="nodeset" select="Extends"/>
						<xsl:apply-templates select="current()" mode="inheritance">
							<xsl:with-param name="nodeset" select="$nodeset"/>
							<xsl:with-param name="noderefs" select="'true'"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Find direct subClasses -->
	<xsl:template match="Classifier" mode="subClasses">
		<xsl:choose>
			<!-- Process classes -->
			<xsl:when test="@type='Class'">
				<xsl:variable name="nodeset" select="//Classifier[@type='Class'][Extends[@idref=current()/@id][not(@indirectly='true')]]" />
				<xsl:apply-templates select="current()" mode="inheritance">
					<xsl:with-param name="nodeset" select="$nodeset"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- Process interfaces -->
			<xsl:otherwise>
				<xsl:variable name="nodeset" select="//Classifier[@type='Class' or @type='Struct'][Implements[@idref=current()/@id][not(@indirectly='true')]]" />
				<xsl:apply-templates select="current()" mode="inheritance">
					<xsl:with-param name="nodeset" select="$nodeset"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Find subInterfaces -->
	<xsl:template match="Classifier" mode="subInterfaces">
		<xsl:variable name="nodeset" select="//Classifier[@type='Interface'][Extends[@idref=current()/@id]]"/>
		<xsl:apply-templates select="current()" mode="inheritance">
			<xsl:with-param name="nodeset" select="$nodeset"/>
		</xsl:apply-templates>
	</xsl:template>

</xsl:stylesheet>
